//==========================================================================
// Directional Diffuse Lighting for jGpuSkin Animation Objects
// For use with objects which have a maximum of 1 bone influence per vertex.
// By Jesse George - revenant_chaos@yahoo.com
//==========================================================================
#include "jGpuSkin_Include.fxi"

//--------------
// un-tweaks
//--------------
   matrix World:World;
   matrix WorldVP:WorldViewProjection;
   matrix ViewProj:ViewProjection; 
   float4 BonePalette[PaletteSize*3]:JGS;

//--------------
// tweaks
//--------------
   float3 Ambient={0.1f,0.1f,0.1f};
   float3 LightDir={0.5f,-0.5f,0.5f};
   float3 LightColor={1.0f,1.0f,1.0f};


//--------------
// Textures
//--------------
   texture BaseTX <string Name="";>;	
   sampler2D Base = sampler_state 
    {
 	texture = <BaseTX>;
	mipfilter = anisotropic;
	minfilter = anisotropic;
	magfilter = anisotropic;
    };

//--------------
// structs 
//--------------
   struct input
     {
 	float4 Pos:POSITION;
	float3 Normal:NORMAL;
 	float2 UV:TEXCOORD0; 
 	float BoneIndex:TEXCOORD1; 
     };
   struct output
     {
	float4 OPos:POSITION; 
	float3 WNormal:TEXCOORD0;
 	float2 Tex:TEXCOORD1; 
     };

//--------------
// vertex shader
//--------------
   output VS(input IN) 
     {
 	output OUT;
	int index = IN.BoneIndex*3;
	matrix model = float4x4(BonePalette[index], BonePalette[index+1], BonePalette[index+2], 0.0,0.0,0.0,1.0);
    	OUT.WNormal=normalize(mul(mul((float3x3)model, IN.Normal),World));
	OUT.OPos=mul(float4(mul(model,IN.Pos).xyz,1.0),WorldVP); 
 	OUT.Tex=IN.UV;
	return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS(output IN)  : COLOR
     {
	float4 Texture=tex2D(Base,IN.Tex); 
	float Light=saturate(dot(IN.WNormal,normalize(-LightDir)));
	return Texture*float4(Light+Ambient,1.0f);
     }

//--------------
// techniques   
//--------------
   technique Diffuse
   {
      pass p1
      {		
         vertexShader = compile vs_2_0 VS(); 
         pixelShader  = compile ps_2_0 PS();
      }
   }